//=============================================================================
// Metals.
//=============================================================================
class Ore extends Metals;

#exec MESH IMPORT MESH=Ore ANIVFILE=C:\DeusEx\MODELS\Ore_a.3d DATAFILE=C:\DeusEx\MODELS\Ore_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Ore X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Ore SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Ore SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=Ore MESH=Ore
#exec MESHMAP SCALE MESHMAP=Ore X=.9 Y=.9 Z=.9

#exec TEXTURE IMPORT NAME=OreTex1 FILE=C:\DeusEx\Markistan\textures\Ore.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=OreTex1 FILE=C:\DeusEx\Markistan\textures\Ore.pcx GROUP=Skins PALETTE=OreTex1

#exec MESHMAP SETTEXTURE MESHMAP=Ore NUM=1 TEXTURE=OreTex1

auto state Pickup
{
	function Frob(Actor Frobber, Inventory frobWith)
	{
		local MarkusGrayMale player;

		Super.Frob(Frobber, frobWith);

		player = MarkusGrayMale(Frobber);

		if (player != None)
		{
			player.Metals += numMetals;
			player.ClientMessage(Sprintf(msgMetalsAdded, numMetals));
			player.FrobTarget = None;
			Destroy();
		}
	}
}

defaultproperties
{
     numMetals=25
     msgMetalsAdded="%d metals added"
     ItemName="Ore"
     PickupViewMesh=LodMesh'Markistan.Ore'
     Mesh=LodMesh'Markistan.Ore'
     CollisionRadius=8.000000
     CollisionHeight=12.000000
     Mass=20.000000
     Buoyancy=30.000000
}
